/*
 * SB - Super Bombe.
 *
 * Public domain software.
 *
 * Author Nik Shaylor (nshaylor@tcp.co.uk)
 */

#include <stdio.h>
#include <stdlib.h>

/*
 * Scrambler table initialisation
 */


char rotors[6][2][26] =
    {
        { "ABCDEFGHIJKLMNOPQRSTUVWXYZ",    /* Rotor 0 */
          "ABCDEFGHIJKLMNOPQRSTUVWXYZ" },
          
        { "EKMFLGDQVZNTOWYHXUSPAIBRCJ",    /* Rotor 1 */
          "UWYGADFPVZBECKMTHXSLRINQOJ" },
                          
        { "AJDKSIRUXBLHWTMCQGZNPYFVOE",    /* Rotor 2 */
          "AJPCZWRLFBDKOTYUQGENHXMIVS" },
                          
        { "BDFHJLCPRTXVZNYEIWGAKMUSQO",    /* Rotor 3 */
          "TAGBPCSDQEUFVNZHYIXJWLRKOM" },
                       
        { "ESOVPZJAYQUIRHXLNFTGKDCMWB",    /* Rotor 4 */
          "HZWVARTNLGUPXQCEJMBSKDYOIF" },
                       
        { "VZBRGITYUPSDNHLXAWMJQOFECK",    /* Rotor 5 */ 
          "QCYLXWENFTZOSMVJUDKGIARPHB" }
     };

char notches[6]  = "ZQEVJZ"; /* notches for rotors 0-5 */
char refs[1][26] = { "YRUHQSLDPXNGOKMIEBFZCWVJAT" };

/* Initialisaton Code */

#define TABLEOVERRUN 256

int fastRotor;
int middRotor;
int slowRotor;

char scramblerTable[(26*26*26)+TABLEOVERRUN][32];

char fastRotorSetting[(26*26*26)+TABLEOVERRUN];
char middRotorSetting[(26*26*26)+TABLEOVERRUN];
char slowRotorSetting[(26*26*26)+TABLEOVERRUN];

int  tableLimit = -1;



void buildScramblerTable()
    {
    int i, j, k;
    int fastPos   = 0;
    int middPos   = 0;
    int slowPos   = 0;
    int fastNotch = notches[fastRotor] - 65;
    int middNotch = notches[middRotor] - 65;

    char fastFor[3*26];
    char middFor[3*26];
    char slowFor[3*26];
    char reflect[3*26];
    char fastRev[3*26];
    char middRev[3*26];
    char slowRev[3*26];
    
/*
 * Setup rotors - Load up the fast, middle, and slow rotor definitions.
 * There are three copies of each sequences which allows the removeral
 * of a number of overflow tests that would otherwise be required.
 */

    for( i = 0 ; i < 26 ; i++ )
        {
        fastFor[i] = fastFor[i+26] = fastFor[i+52] = rotors[fastRotor][0][i] - 65;
        middFor[i] = middFor[i+26] = middFor[i+52] = rotors[middRotor][0][i] - 65;
        slowFor[i] = slowFor[i+26] = slowFor[i+52] = rotors[slowRotor][0][i] - 65;        
        fastRev[i] = fastRev[i+26] = fastRev[i+52] = rotors[fastRotor][1][i] - 65;
        middRev[i] = middRev[i+26] = middRev[i+52] = rotors[middRotor][1][i] - 65;
        slowRev[i] = slowRev[i+26] = slowRev[i+52] = rotors[slowRotor][1][i] - 65;
        reflect[i] = reflect[i+26] = reflect[i+52] = refs[0][i]              - 65;        
        } 

/*
 * Run through all the possible rotor settings
 */

    for( i = 0 ;; i++ )
        {
        slowRotorSetting[i] = slowPos;
        middRotorSetting[i] = middPos;
        fastRotorSetting[i] = fastPos;

/* This NOTCHES option is wrong */
#ifdef NOTCHES          
        if( middPos == middNotch || fastPos == fastNotch )
            {          
            if( middPos == middNotch )
                {
                if( ++slowPos == 26 )
                    slowPos = 0;
                }

            if( ++middPos == 26 )
               middPos = 0;
            }

        if( ++fastPos == 26 )
            fastPos = 0;
#else
        if( ++fastPos == 26 )
            {
            fastPos = 0;
            
            if( ++middPos == 26 )
                {
                middPos = 0;
                
                if( ++slowPos == 26 )
                    slowPos = 0;
                }
            }
#endif
        for( j = 0 ; j < 26 ; j++ )
            {
            int ch = j;
        
            ch = fastFor[ 26 + ch + fastPos ] - fastPos;
            ch = middFor[ 26 + ch + middPos ] - middPos;
            ch = slowFor[ 26 + ch + slowPos ] - slowPos;
            ch = reflect[ 26 + ch           ];
            ch = slowRev[ 26 + ch + slowPos ] - slowPos;
            ch = middRev[ 26 + ch + middPos ] - middPos;
            ch = fastRev[ 26 + ch + fastPos ] - fastPos;
            
            if( ch < 0 )
               ch += 26;

            scramblerTable[i][j]  = ch;
            }
            
        if( fastPos+middPos+slowPos == 0 )
            break;     
        }

    tableLimit = ++i;

/*
 * Wrap the first TABLEOVERRUN elements onto the end of the table thus
 * built. This extension means we do not have to worry about the crib
 * position lookups running of the end of the table when we get to the
 * end of the search. No crib position can be greater then TABLEOVERRUN
 */

    for( k = 0 ; k < TABLEOVERRUN ; k++ )
        {
        for( j = 0 ; j < 26 ; j++ )
            scramblerTable[i][j] = scramblerTable[k][j];

        i++;
        }
    
    }


void printSequence( int i )
    {
    printf( "%d%d%d-%c%c%c   ",
            slowRotor,
            middRotor,
            fastRotor,
            slowRotorSetting[i] + 65,
            middRotorSetting[i] + 65,
            fastRotorSetting[i] + 65
          );
    }


/*
 * Main program
 */



#define LetterA ('A' - 65)
#define LetterB ('B' - 65)
#define LetterC ('C' - 65)
#define LetterD ('D' - 65)
#define LetterE ('E' - 65)
#define LetterF ('F' - 65)
#define LetterG ('G' - 65)
#define LetterH ('H' - 65)
#define LetterI ('I' - 65)
#define LetterJ ('J' - 65)
#define LetterK ('K' - 65)
#define LetterL ('L' - 65)
#define LetterM ('M' - 65)
#define LetterN ('N' - 65)
#define LetterO ('O' - 65)
#define LetterP ('P' - 65)
#define LetterQ ('Q' - 65)
#define LetterR ('R' - 65)
#define LetterS ('S' - 65)
#define LetterT ('T' - 65)
#define LetterU ('U' - 65)
#define LetterV ('V' - 65)
#define LetterW ('W' - 65)
#define LetterX ('X' - 65)
#define LetterY ('Y' - 65)
#define LetterZ ('Z' - 65)

char cableA[26];
char cableB[26];
char cableC[26];
char cableD[26];
char cableE[26];
char cableF[26];
char cableG[26];
char cableH[26];
char cableI[26];
char cableJ[26];
char cableK[26];
char cableL[26];
char cableM[26];
char cableN[26];
char cableO[26];
char cableP[26];
char cableQ[26];
char cableR[26];
char cableS[26];
char cableT[26];
char cableU[26];
char cableV[26];
char cableW[26];
char cableX[26];
char cableY[26];
char cableZ[26];

char *cable[26] = { cableA, cableB, cableC, cableD, cableE, cableF,
                    cableG, cableH, cableI, cableJ, cableK, cableL,
                    cableM, cableN, cableO, cableP, cableQ, cableR,
                    cableS, cableT, cableU, cableV, cableW, cableX,
                    cableY, cableZ };


void setOnCableA( int ch );
void setOnCableB( int ch );
void setOnCableC( int ch );
void setOnCableD( int ch );
void setOnCableE( int ch );
void setOnCableF( int ch );
void setOnCableG( int ch );
void setOnCableH( int ch );
void setOnCableI( int ch );
void setOnCableJ( int ch );
void setOnCableK( int ch );
void setOnCableL( int ch );
void setOnCableM( int ch );
void setOnCableN( int ch );
void setOnCableO( int ch );
void setOnCableP( int ch );
void setOnCableQ( int ch );
void setOnCableR( int ch );
void setOnCableS( int ch );
void setOnCableT( int ch );
void setOnCableU( int ch );
void setOnCableV( int ch );
void setOnCableW( int ch );
void setOnCableX( int ch );
void setOnCableY( int ch );
void setOnCableZ( int ch );


void clearCables()
    {
    int j;
    for( j = 0 ; j < 26 ; j++ )
        {
        cableA[j] = 0;
        cableB[j] = 0;
        cableC[j] = 0;
        cableD[j] = 0;
        cableE[j] = 0;
        cableF[j] = 0;
        cableG[j] = 0;
        cableH[j] = 0;
        cableI[j] = 0;
        cableJ[j] = 0;
        cableK[j] = 0;
        cableL[j] = 0;
        cableM[j] = 0;
        cableN[j] = 0;
        cableO[j] = 0;
        cableP[j] = 0;
        cableQ[j] = 0;
        cableR[j] = 0;
        cableS[j] = 0;
        cableT[j] = 0;
        cableU[j] = 0;
        cableV[j] = 0;
        cableW[j] = 0;
        cableX[j] = 0;
        cableY[j] = 0;
        cableZ[j] = 0;
        }
    }


void setDiagonal( int cable, int ch )
    {
    switch( cable )
        {
        case LetterA: setOnCableA( ch ); return;
        case LetterB: setOnCableB( ch ); return;
        case LetterC: setOnCableC( ch ); return;
        case LetterD: setOnCableD( ch ); return;
        case LetterE: setOnCableE( ch ); return;
        case LetterF: setOnCableF( ch ); return;
        case LetterG: setOnCableG( ch ); return;
        case LetterH: setOnCableH( ch ); return;
        case LetterI: setOnCableI( ch ); return;
        case LetterJ: setOnCableJ( ch ); return;
        case LetterK: setOnCableK( ch ); return;
        case LetterL: setOnCableL( ch ); return;
        case LetterM: setOnCableM( ch ); return;
        case LetterN: setOnCableN( ch ); return;
        case LetterO: setOnCableO( ch ); return;
        case LetterP: setOnCableP( ch ); return;
        case LetterQ: setOnCableQ( ch ); return;
        case LetterR: setOnCableR( ch ); return;
        case LetterS: setOnCableS( ch ); return;
        case LetterT: setOnCableT( ch ); return;
        case LetterU: setOnCableU( ch ); return;
        case LetterV: setOnCableV( ch ); return;
        case LetterW: setOnCableW( ch ); return;
        case LetterX: setOnCableX( ch ); return;
        case LetterY: setOnCableY( ch ); return;
        case LetterZ: setOnCableZ( ch ); return;
        }
    }
    
char *plainText;
char *cipherText;

int testCable;
int testWire;

int   seq = 0;    // Sequence of rotor positions
char *seqEntry;   // Character pointer into scramble table

#define scramble( pos, ch ) seqEntry[pos*32+ch]

char plug[26];
char patch[26];
        
void drop()
    {
    int i, j;
    
    printSequence( seq );

    for( i = 0 ; i < 26 ; i++ )
        {
        patch[i] = 0;
        plug[i]  = i;
        }

    for( i = 0 ; i < 26 ; i++ )
        {
        int count = 0;
        
        clearCables();
        setDiagonal( i, i );

        for( j = 0 ; j < 26 ; j++ )
            if( cable[i][j] != 0 )
                count++;

        switch( count )
            {
            case 1:
                patch[i] = 1;
                break;
                
            case 25:
                for( j = 0 ; j < 26 ; j++ )
                    if( cable[i][j] == 0 )
                        break;

                if( patch[j]+patch[i] == 0 )
                    {
                    patch[i] = 1;
                    patch[j] = 1;
                    plug[i] = j;
                    plug[j] = i;

                    printf( "(%c%c) ", i+65, j+65 );
                    }
                    
                break;
            }
        }

    for( i = 0 ; i < 26 ; i++ )
        {
        if( patch[i] == 0 )
            printf( "(%c?) ", i+65 );
        }
        
    printf( "\n" );
    }


void tryRotorPosition()
    {
    int i, count, drops = 0;

    printf( "Trying rotors [%d%d%d]\n", slowRotor, middRotor, fastRotor );
    
    for( seq = 0 ; seq < tableLimit ; seq++ )
        {
        seqEntry = (char *)&scramblerTable[seq][0];

        count = 0;
        
        clearCables();
        setDiagonal( testCable, testWire );
        
        for( i = 0 ; i < 26 ; i++ )
            if( cable[testCable][i] != 0 )
                count++;
                
        if( count == 1 || count == 25 )
            {
            drops++;
            drop();
            }
        }
    }


void tryOrder( int a, int b, int c )
    {   
    slowRotor = a;
    middRotor = b;
    fastRotor = c;
    buildScramblerTable();
    tryRotorPosition();
    }


void tryRotors( int a, int b, int c )
    {
    tryOrder( a, b, c );
    tryOrder( b, c, a );
    tryOrder( c, a, b );
    tryOrder( b, a, c );
    tryOrder( a, c, b );
    tryOrder( c, b, a );
    }


void tryAllRotors()
    {    
    tryRotors( 1, 2, 3 );
    tryRotors( 1, 2, 4 );
    tryRotors( 1, 2, 5 );
    tryRotors( 1, 3, 4 );
    tryRotors( 1, 3, 5 );
    tryRotors( 1, 4, 5 );
    tryRotors( 2, 3, 4 );
    tryRotors( 2, 3, 5 );
    tryRotors( 2, 4, 5 );
    tryRotors( 3, 4, 5 );
    }


void realMain()
    {
    printf( "plain  = %s\ncipher = %s\n", plainText, cipherText );
    printf( "cable = %c wire = %c\n", testCable+65, testWire+65 );
    tryAllRotors();
    printf( "Done\n" );
    }



